<?php require BASE_PATH . '/app/views/layouts/header.php'; ?>
<style>
.topbar{background:#0ea5e9;color:#fff;padding:14px 28px;font-weight:600;}
.container{max-width:1000px;margin:40px auto;background:#fff;padding:30px;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.08);}
.actions{display:flex;gap:10px;flex-wrap:wrap;align-items:center}
a.btn,button.btn{padding:10px 14px;border-radius:10px;text-decoration:none;font-weight:600;border:none;cursor:pointer;display:inline-block}
.btn-add{background:#2563eb;color:#fff;}
.btn-edit{background:#10b981;color:#fff;}
.btn-del{background:#ef4444;color:#fff;}
.btn:hover{opacity:.9}
.search{margin-left:auto;display:flex;gap:8px}
.search input,.search select{padding:10px;border:1px solid #cbd5e1;border-radius:10px;min-width:180px}
table{width:100%;border-collapse:collapse;margin-top:16px}
th,td{padding:10px;border-bottom:1px solid #e2e8f0;text-align:left}
th{background:#f1f5f9}
.badge{background:#e2e8f0;border-radius:999px;padding:4px 10px;font-size:.8rem}
.small{color:#64748b;font-size:.85rem}
</style>

<div class="topbar">Data Ruangan</div>
<div class="container">
  <div class="actions">
    <a href="index.php?route=ruangan_add" class="btn btn-add">+ Tambah Ruangan</a>
    <form class="search" method="get" action="index.php">
      <input type="hidden" name="route" value="ruangan">
      <input type="text" name="q" value="<?= htmlspecialchars($_GET['q'] ?? '') ?>" placeholder="Cari kode ruangan...">
      <select name="id_gedung">
        <option value="0">Semua Gedung</option>
        <?php foreach ($gedungList as $g): ?>
          <option value="<?= (int)$g['id_gedung'] ?>" <?= (isset($_GET['id_gedung']) && (int)$_GET['id_gedung']==(int)$g['id_gedung'])?'selected':'' ?>>
            <?= htmlspecialchars($g['nama_gedung']) ?> (<?= htmlspecialchars($g['lokasi']) ?>)
          </option>
        <?php endforeach; ?>
      </select>
      <button class="btn" style="background:#0ea5e9;color:#fff;">Filter</button>
    </form>
  </div>

  <table>
    <tr>
      <th style="width:80px;">ID</th>
      <th style="width:160px;">Kode Ruangan</th>
      <th>Gedung</th>
      <th style="width:140px;">Kapasitas</th>
      <th>Lokasi Ruangan</th>
      <th>Keterangan</th>
      <th style="width:220px;">Aksi</th>
    </tr>
    <?php foreach ($list as $r): ?>
<tr>
    <td><span class="badge"><?= (int)$r['id_ruangan'] ?></span></td>

    <td><b><?= htmlspecialchars($r['kode_ruangan']) ?></b></td>

    <td>
      <?= htmlspecialchars($r['nama_gedung']) ?>
      <span class="small">— <?= htmlspecialchars($r['lokasi_gedung'] ?? '') ?></span>
    </td>

    <td><?= (int)$r['kapasitas'] ?> orang</td>

    <td><?= htmlspecialchars($r['lokasi_ruangan']) ?></td>

    <td><?= htmlspecialchars($r['keterangan']) ?></td>

    <td>
      <a class="btn btn-edit" href="index.php?route=ruangan_edit&id=<?= (int)$r['id_ruangan'] ?>">Edit</a>
      <a class="btn btn-del" 
         href="index.php?route=ruangan_delete&id=<?= (int)$r['id_ruangan'] ?>"
         onclick="return confirm('Hapus ruangan ini?')">Hapus</a>
    </td>
</tr>
<?php endforeach; ?>
  </table>

  <p style="margin-top:20px;"><a href="index.php">← Kembali ke Dashboard</a></p>
</div>
<?php require BASE_PATH . '/app/views/layouts/footer.php'; ?>
