<?php require BASE_PATH . '/app/views/layouts/header.php'; ?>
<style>
.topbar{background:#0ea5e9;color:#fff;padding:14px 28px;font-weight:600;}
.wrap{max-width:1100px;margin:32px auto;}
.card{background:#fff;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.08);padding:20px;}
.formgrid{display:grid;grid-template-columns:repeat(6,1fr);gap:10px}
.formgrid input,.formgrid select{padding:10px;border:1px solid #cbd5e1;border-radius:10px}
.btn{padding:10px 14px;border-radius:10px;border:none;background:#2563eb;color:#fff;font-weight:600;cursor:pointer}
.btn-light{background:#e2e8f0;color:#111827}
table{width:100%;border-collapse:collapse;margin-top:16px}
th,td{padding:10px;border-bottom:1px solid #e2e8f0;text-align:left}
th{background:#f8fafc}
.badge{padding:4px 10px;border-radius:999px;font-size:.8rem;background:#e2e8f0}
.tag{padding:4px 10px;border-radius:999px;font-size:.8rem;color:#fff}
.t-pengajuan{background:#7c3aed}.t-booking{background:#059669}
.a-dibuat{background:#3b82f6}.a-disetujui{background:#10b981}.a-ditolak{background:#ef4444}.a-dibatalkan{background:#475569}
.small{color:#64748b;font-size:.85rem}
</style>

<div class="topbar">Log Aktivitas</div>
<div class="wrap">
  <div class="card">
    <form method="get" action="index.php" class="formgrid">
      <input type="hidden" name="route" value="log">
      <select name="jenis">
        <option value="">Semua Jenis</option>
        <option value="pengajuan_jadwal" <?= (($_GET['jenis'] ?? '')==='pengajuan_jadwal')?'selected':'' ?>>Pengajuan Jadwal</option>
        <option value="booking_ruangan"  <?= (($_GET['jenis'] ?? '')==='booking_ruangan')?'selected':''  ?>>Booking Ruangan</option>
      </select>
      <select name="aksi">
        <option value="">Semua Aksi</option>
        <option value="dibuat"     <?= (($_GET['aksi'] ?? '')==='dibuat')?'selected':''     ?>>Dibuat</option>
        <option value="disetujui"  <?= (($_GET['aksi'] ?? '')==='disetujui')?'selected':''  ?>>Disetujui</option>
        <option value="ditolak"    <?= (($_GET['aksi'] ?? '')==='ditolak')?'selected':''    ?>>Ditolak</option>
        <option value="dibatalkan" <?= (($_GET['aksi'] ?? '')==='dibatalkan')?'selected':'' ?>>Dibatalkan</option>
      </select>
      <input type="date" name="dari"   value="<?= htmlspecialchars($_GET['dari']   ?? '') ?>">
      <input type="date" name="sampai" value="<?= htmlspecialchars($_GET['sampai'] ?? '') ?>">
      <input type="text" name="q" placeholder="Cari oleh / ID referensi..." value="<?= htmlspecialchars($_GET['q'] ?? '') ?>" style="grid-column:1 / span 2">
      <button class="btn" type="submit">Filter</button>
      <a class="btn btn-light" href="index.php?route=log">Reset</a>
    </form>
  </div>

  <div class="card" style="margin-top:16px;">
    <table>
      <tr>
        <th>Waktu</th><th>Jenis</th><th>Aksi</th><th>ID Ref</th><th>Oleh</th>
      </tr>
      <?php if (empty($list)): ?>
        <tr><td colspan="5" style="text-align:center;color:#64748b;padding:18px;">Belum ada log.</td></tr>
      <?php else: foreach($list as $r): ?>
        <tr>
          <td><?= htmlspecialchars($r['waktu']) ?></td>
          <td>
            <?php if ($r['jenis']==='pengajuan_jadwal'): ?>
              <span class="tag t-pengajuan">Pengajuan Jadwal</span>
            <?php else: ?>
              <span class="tag t-booking">Booking Ruangan</span>
            <?php endif; ?>
          </td>
          <td>
            <?php
              $cls = 'a-dibuat';
              if ($r['aksi']==='disetujui') $cls='a-disetujui';
              elseif ($r['aksi']==='ditolak') $cls='a-ditolak';
              elseif ($r['aksi']==='dibatalkan') $cls='a-dibatalkan';
            ?>
            <span class="tag <?= $cls ?>"><?= htmlspecialchars($r['aksi']) ?></span>
          </td>
          <td><span class="badge"><?= (int)$r['id_referensi'] ?></span></td>
          <td><?= htmlspecialchars($r['oleh']) ?></td>
        </tr>
      <?php endforeach; endif; ?>
    </table>

    <p class="small" style="margin-top:10px;">Catatan: “ID Ref” adalah kunci pada objek asal (ID Pengajuan/Booking).</p>
    <p style="margin-top:16px;"><a href="index.php">← Kembali ke Dashboard</a></p>
  </div>
</div>
<?php require BASE_PATH . '/app/views/layouts/footer.php'; ?>
