<?php
// app/views/layouts/sidebar.php
// Konten menu navigasi dinamis berdasarkan peran

$role = $_SESSION['role'] ?? 'guest';
?>

<div class="sidebar">
    <div class="list-group list-group-flush pt-4">
        <a href="index.php?controller=Dashboard&method=index" class="list-group-item list-group-item-action bg-dark text-white border-0">
            🏠 Dashboard Utama
        </a>
        <hr class="text-white-50 my-1">

        <?php if ($role == 'admin'): // ADMIN (UPMI) ?>
            <a class="list-group-item list-group-item-action bg-dark text-white" href="#master-sub" data-bs-toggle="collapse">
                Manajemen Data Master
            </a>
            <div class="collapse show" id="master-sub">
                <a href="index.php?controller=Ruangan" class="list-group-item list-group-item-action bg-secondary text-white-50">Ruangan</a>
                <a href="index.php?controller=Matkul" class="list-group-item list-group-item-action bg-secondary text-white-50">Mata Kuliah</a>
                <a href="index.php?controller=Dosen" class="list-group-item list-group-item-action bg-secondary text-white-50">Dosen & User</a>
                <a href="index.php?controller=Prodi" class="list-group-item list-group-item-action bg-secondary text-white-50">Prodi & Kelas</a>
            </div>

            <a href="index.php?controller=Pengajuan&method=persetujuan" class="list-group-item list-group-item-action bg-dark text-white">
                ✅ Persetujuan Pengajuan
            </a>
            
            <a href="index.php?controller=Jadwal&method=viewJadwal" class="list-group-item list-group-item-action bg-dark text-white">
                📅 Tampilan Jadwal Lengkap
            </a>

        <?php elseif ($role == 'prodi'): // PRODI ?>
            <a href="index.php?controller=Pengajuan&method=prodiForm" class="list-group-item list-group-item-action bg-dark text-white">
                📝 Pengajuan Jadwal Semester
            </a>
            <a href="index.php?controller=Pengajuan&method=prodiStatus" class="list-group-item list-group-item-action bg-dark text-white">
                📋 Status Pengajuan
            </a>
            <a href="index.php?controller=Jadwal&method=prodiView" class="list-group-item list-group-item-action bg-dark text-white">
                📅 Jadwal Prodi Saya
            </a>
            
        <?php elseif ($role == 'dosen'): // DOSEN ?>
            <a href="index.php?controller=Booking&method=formBooking" class="list-group-item list-group-item-action bg-dark text-white">
                🗓️ Booking Ruangan/Pengganti
            </a>
            <a href="index.php?controller=Booking&method=statusBooking" class="list-group-item list-group-item-action bg-dark text-white">
                📋 Status Booking Saya
            </a>
            <a href="index.php?controller=Jadwal&method=dosenView" class="list-group-item list-group-item-action bg-dark text-white">
                📚 Jadwal Mengajar Saya
            </a>
            
        <?php endif; ?>

        <hr class="text-white-50 my-1">
        <a href="index.php?controller=Auth&method=logout" class="list-group-item list-group-item-action bg-dark text-white">
            Keluar
        </a>
    </div>
</div>
