<?php include BASE_PATH . '/app/views/layouts/header.php'; ?>

<div style="max-width:900px;margin:40px auto;background:#fff;padding:30px;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.08);">
    <h2 style="color:#1e3a8a;">📚 Daftar Kelas</h2>

    <?php if (isset($_SESSION['message'])): ?>
        <div style="padding:12px;background:<?= $_SESSION['message']['type'] === 'success' ? '#d1fae5' : '#fee2e2' ?>;color:<?= $_SESSION['message']['type'] === 'success' ? '#065f46' : '#991b1b' ?>;border-radius:8px;margin-bottom:20px;">
            <?= htmlspecialchars($_SESSION['message']['text']) ?>
        </div>
        <?php unset($_SESSION['message']); ?>
    <?php endif; ?>

    <a href="index.php?route=kelas_add" style="display:inline-block;margin-bottom:24px;padding:10px 20px;background:#2563eb;color:#fff;text-decoration:none;border-radius:8px;font-weight:600;">➕ Tambah Kelas</a>

    <div style="overflow-x:auto;">
        <table style="width:100%;border-collapse:collapse;margin-top:16px;">
            <thead>
                <tr style="background:#f1f5f9;">
                    <th style="padding:12px;text-align:left;border:1px solid #e2e8f0;">Kode Kelas</th>
                    <th style="padding:12px;text-align:left;border:1px solid #e2e8f0;">Program Studi</th>
                    <th style="padding:12px;text-align:left;border:1px solid #e2e8f0;">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($kelas)): ?>
                    <?php foreach ($kelas as $k): ?>
                    <tr style="border-bottom:1px solid #e2e8f0;">
                        <td style="padding:12px;"><?= htmlspecialchars($k['kode_kelas']) ?></td>
                        <td style="padding:12px;"><?= htmlspecialchars($k['nama_prodi'] ?? '—') ?></td>
                        <td style="padding:12px;">
                            <a href="index.php?route=kelas_edit&id=<?= $k['id_kelas'] ?>" style="margin-right:8px;padding:6px 12px;background:#fbbf24;color:#000;text-decoration:none;border-radius:4px;font-size:14px;">Edit</a>
                            <a href="index.php?route=kelas_delete&id=<?= $k['id_kelas'] ?>" onclick="return confirm('Yakin ingin menghapus kelas ini?')" style="padding:6px 12px;background:#ef4444;color:#fff;text-decoration:none;border-radius:4px;font-size:14px;">Hapus</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="3" style="padding:20px;text-align:center;color:#6b7280;">Belum ada data kelas.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

      <p style="margin-top:20px;"><a href="index.php">← Kembali ke Dashboard</a></p>

<?php include BASE_PATH . '/app/views/layouts/footer.php'; ?>