<?php include BASE_PATH . '/app/views/layouts/header.php'; ?>

<div style="max-width:900px;margin:40px auto;background:#fff;padding:30px;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.08);">
    <h2 style="color:#1e3a8a;">✏ Edit Kelas: <?= htmlspecialchars($kelas['kode_kelas']) ?></h2>

    <?php if (isset($_SESSION['message'])): ?>
        <div style="padding:12px;background:<?= $_SESSION['message']['type'] === 'success' ? '#d1fae5' : '#fee2e2' ?>;color:<?= $_SESSION['message']['type'] === 'success' ? '#065f46' : '#991b1b' ?>;border-radius:8px;margin-bottom:20px;">
            <?= htmlspecialchars($_SESSION['message']['text']) ?>
        </div>
        <?php unset($_SESSION['message']); ?>
    <?php endif; ?>

    <form method="POST" action="">
        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Kode Kelas</label>
            <input type="text" name="kode_kelas" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" value="<?= htmlspecialchars($kelas['kode_kelas']) ?>" maxlength="20" required>
        </div>

        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Program Studi</label>
            <select name="id_prodi" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" required>
                <option value="">-- Pilih Program Studi --</option>
                <?php foreach ($prodiList as $prodi): ?>
                    <option value="<?= (int)$prodi['id_prodi'] ?>" 
                        <?= ((int)$kelas['id_prodi'] === (int)$prodi['id_prodi']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($prodi['nama_prodi']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <button type="submit" style="padding:12px 24px;background:#2563eb;color:#fff;border:none;border-radius:8px;font-weight:600;cursor:pointer;">Update Kelas</button>
        <a href="index.php?route=kelas" style="margin-left:10px;padding:12px 24px;background:#9ca3af;color:#fff;text-decoration:none;border-radius:8px;font-weight:600;">Batal</a>
    </form>
</div>

<?php include BASE_PATH . '/app/views/layouts/footer.php'; ?>