<?php include BASE_PATH . '/app/views/layouts/header.php'; ?>

<div style="max-width:900px;margin:40px auto;background:#fff;padding:30px;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.08);">
    <h2 style="color:#1e3a8a;">📝 Edit Jadwal Perkuliahan</h2>

    <?php if (isset($_SESSION['message'])): ?>
        <div style="padding:12px;background:<?= $_SESSION['message']['type'] === 'success' ? '#d1fae5' : '#fee2e2' ?>;color:<?= $_SESSION['message']['type'] === 'success' ? '#065f46' : '#991b1b' ?>;border-radius:8px;margin-bottom:20px;">
            <?= htmlspecialchars($_SESSION['message']['text']) ?>
        </div>
        <?php unset($_SESSION['message']); ?>
    <?php endif; ?>

    <form method="POST" action="">
        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Hari</label>
            <select name="id_hari" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" required>
                <option value="">-- Pilih Hari --</option>
                <?php foreach ($hariList as $h): ?>
                    <option value="<?= (int)$h['id_hari'] ?>" <?= ((int)$jadwal['id_hari'] === (int)$h['id_hari']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($h['nama_hari']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Slot Waktu</label>
            <select name="id_slot" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" required>
                <option value="">-- Pilih Slot --</option>
                <?php foreach ($slotList as $s): ?>
                    <option value="<?= (int)$s['id_slot'] ?>" <?= ((int)$jadwal['id_slot'] === (int)$s['id_slot']) ? 'selected' : '' ?>>
                        Sesi <?= (int)$s['id_slot'] ?> (<?= htmlspecialchars($s['jam_mulai']) ?>–<?= htmlspecialchars($s['jam_selesai']) ?>)
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Ruangan</label>
            <select name="id_ruangan" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" required>
                <option value="">-- Pilih Ruangan --</option>
                <?php foreach ($ruangList as $r): ?>
                    <option value="<?= (int)$r['id_ruangan'] ?>" <?= ((int)$jadwal['id_ruangan'] === (int)$r['id_ruangan']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($r['kode_ruangan']) ?> — <?= htmlspecialchars($r['nama_gedung'] ?? '') ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Mata Kuliah</label>
            <select name="id_mk" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;">
                <option value="">— Tidak ada (misal: praktikum/kosong) —</option>
                <?php foreach ($mkList as $mk): ?>
                    <option value="<?= (int)$mk['id_mk'] ?>" <?= ((int)$jadwal['id_mk'] === (int)$mk['id_mk']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($mk['nama_mk']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Kelas</label>
            <select name="id_kelas" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;">
                <option value="">— Tidak ada —</option>
                <?php foreach ($kelasList as $k): ?>
                    <option value="<?= (int)$k['id_kelas'] ?>" <?= ((int)$jadwal['id_kelas'] === (int)$k['id_kelas']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($k['kode_kelas']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Dosen</label>
            <select name="id_dosen" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" required>
                <option value="">-- Pilih Dosen --</option>
                <?php foreach ($dosenList as $d): ?>
                    <option value="<?= (int)$d['id_dosen'] ?>" <?= ((int)$jadwal['id_dosen'] === (int)$d['id_dosen']) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($d['nama_lengkap']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Jumlah SKS</label>
            <input type="number" name="jumlah_sks" value="<?= (int)($jadwal['jumlah_sks'] ?? 1) ?>" min="1" max="6" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" required>
        </div>

        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Sumber Jadwal</label>
            <select name="sumber" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;" required>
                <option value="tetap" <?= ($jadwal['sumber'] ?? 'tetap') === 'tetap' ? 'selected' : '' ?>>Tetap</option>
                <option value="pengganti" <?= ($jadwal['sumber'] ?? 'tetap') === 'pengganti' ? 'selected' : '' ?>>Pengganti</option>
            </select>
        </div>

        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Tanggal Mulai (Opsional)</label>
            <input type="date" name="tanggal_mulai" value="<?= htmlspecialchars($jadwal['tanggal_mulai'] ?? '') ?>" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;">
        </div>

        <div style="margin-bottom:16px;">
            <label style="display:block;margin-bottom:4px;font-weight:600;">Tanggal Selesai (Opsional)</label>
            <input type="date" name="tanggal_selesai" value="<?= htmlspecialchars($jadwal['tanggal_selesai'] ?? '') ?>" style="width:100%;padding:10px;border:1px solid #ccc;border-radius:8px;">
        </div>

        <button type="submit" style="padding:12px 24px;background:#2563eb;color:#fff;border:none;border-radius:8px;font-weight:600;cursor:pointer;">Simpan Perubahan</button>
        <a href="index.php?route=jadwal" style="margin-left:10px;padding:12px 24px;background:#9ca3af;color:#fff;text-decoration:none;border-radius:8px;font-weight:600;">Batal</a>
    </form>
</div>

<?php include BASE_PATH . '/app/views/layouts/footer.php'; ?>