<?php require BASE_PATH . '/app/views/layouts/header.php'; ?>
<style>
.topbar{background:#1e40af;color:#fff;padding:14px 28px;font-weight:600;}
.container{max-width:980px;margin:40px auto;background:#fff;padding:30px;border-radius:16px;box-shadow:0 8px 24px rgba(0,0,0,.08);}
.actions{display:flex;gap:10px;flex-wrap:wrap;align-items:center}
a.btn,button.btn{padding:10px 14px;border-radius:10px;text-decoration:none;font-weight:600;border:none;cursor:pointer;display:inline-block}
.btn-add{background:#2563eb;color:#fff;}
.btn-edit{background:#10b981;color:#fff;}
.btn-del{background:#ef4444;color:#fff;}
.btn:hover{opacity:.9}
.search{margin-left:auto;display:flex;gap:8px}
.search input{padding:10px;border:1px solid #cbd5e1;border-radius:10px;min-width:240px}
table{width:100%;border-collapse:collapse;margin-top:16px}
th,td{padding:10px;border-bottom:1px solid #e2e8f0;text-align:left}
th{background:#f1f5f9}
.badge{background:#e2e8f0;border-radius:999px;padding:4px 10px;font-size:.8rem}
</style>

<div class="topbar">Data Dosen</div>
<div class="container">
  <div class="actions">
    <a href="index.php?route=dosen_add" class="btn btn-add">+ Tambah Dosen</a>
    <form class="search" method="get" action="index.php">
      <input type="hidden" name="route" value="dosen">
      <input type="text" name="q" value="<?= htmlspecialchars($_GET['q'] ?? '') ?>" placeholder="Cari inisial / nama...">
      <button class="btn" style="background:#0ea5e9;color:#fff;">Cari</button>
    </form>
  </div>

  <table>
    <tr>
      <th style="width:80px;">ID</th>
      <th style="width:140px;">Inisial</th>
      <th>Nama Lengkap</th>
      <th style="width:220px;">Aksi</th>
    </tr>
    <?php if (empty($list)): ?>
      <tr><td colspan="4" style="text-align:center;color:#64748b;padding:18px;">Data tidak ditemukan.</td></tr>
    <?php else: foreach($list as $r): ?>
      <tr>
        <td><span class="badge"><?= (int)$r['id_dosen'] ?></span></td>
        <td><b><?= htmlspecialchars($r['inisial']) ?></b></td>
        <td><?= htmlspecialchars($r['nama_lengkap']) ?></td>
        <td>
          <a class="btn btn-edit" href="index.php?route=dosen_edit&id=<?= (int)$r['id_dosen'] ?>">Edit</a>
          <a class="btn btn-del" href="index.php?route=dosen_delete&id=<?= (int)$r['id_dosen'] ?>" onclick="return confirm('Hapus dosen ini?')">Hapus</a>
        </td>
      </tr>
    <?php endforeach; endif; ?>
  </table>

  <p style="margin-top:20px;"><a href="index.php">← Kembali ke Dashboard</a></p>
</div>
<?php require BASE_PATH . '/app/views/layouts/footer.php'; ?>

