<?php
require_once __DIR__ . '/../../Config/Database.php';

class UserModel {
    public static function all() {
        $pdo = Database::getConnection();
        $sql = "SELECT u.*, p.nama_prodi, d.nama_lengkap AS nama_dosen_ref
                FROM user u
                LEFT JOIN prodi p ON p.id_prodi = u.id_prodi
                LEFT JOIN dosen d ON d.id_dosen = u.id_dosen
                ORDER BY u.created_at DESC";
        return $pdo->query($sql)->fetchAll();
    }

    public static function find($id) {
        $st = Database::getConnection()->prepare("SELECT * FROM user WHERE id_user = ?");
        $st->execute([$id]);
        return $st->fetch();
    }

    public static function existsUsernameOrEmail($username, $email) {
        $st = Database::getConnection()->prepare("SELECT 1 FROM user WHERE username=? OR email=? LIMIT 1");
        $st->execute([$username, $email]);
        return (bool)$st->fetchColumn();
    }

    public static function create($d) {
        $st = Database::getConnection()->prepare(
            "INSERT INTO user (username,password_hash,nama_lengkap,email,role,id_prodi,id_dosen,aktif,created_at)
             VALUES (?,?,?,?,?,?,?,?,NOW())"
        );
        return $st->execute([
            $d['username'],$d['password_hash'],$d['nama_lengkap'],$d['email'],$d['role'],
            $d['id_prodi']?:NULL,$d['id_dosen']?:NULL,$d['aktif']
        ]);
    }

    public static function update($d) {
        $pdo = Database::getConnection();
        if (!empty($d['password_hash'])) {
            $sql = "UPDATE user SET username=?, password_hash=?, nama_lengkap=?, email=?, role=?, id_prodi=?, id_dosen=? WHERE id_user=?";
            $args = [$d['username'],$d['password_hash'],$d['nama_lengkap'],$d['email'],$d['role'],
                     $d['id_prodi']?:NULL,$d['id_dosen']?:NULL,$d['id_user']];
        } else {
            $sql = "UPDATE user SET username=?, nama_lengkap=?, email=?, role=?, id_prodi=?, id_dosen=? WHERE id_user=?";
            $args = [$d['username'],$d['nama_lengkap'],$d['email'],$d['role'],
                     $d['id_prodi']?:NULL,$d['id_dosen']?:NULL,$d['id_user']];
        }
        $st = $pdo->prepare($sql);
        return $st->execute($args);
    }

    public static function delete($id) {
        $st = Database::getConnection()->prepare("DELETE FROM user WHERE id_user=?");
        return $st->execute([$id]);
    }

    public static function toggleActive($id) {
        $pdo = Database::getConnection();
        $pdo->query("UPDATE user SET aktif = IF(aktif=1,0,1) WHERE id_user=".(int)$id);
    }
}
