<?php
require_once __DIR__ . '/../../Config/Database.php';

class RuanganModel {

    /**
     * Ambil semua ruangan + data gedung terkait
     */
    public static function allWithGedung() {
        $pdo = Database::getConnection();

        $sql = "SELECT 
                    r.id_ruangan,
                    r.kode_ruangan,
                    r.id_gedung,
                    r.kapasitas,
                    r.lokasi_ruangan,
                    r.keterangan,
                    g.nama_gedung,
                    g.lokasi AS lokasi_gedung
                FROM ruangan r
                INNER JOIN gedung g ON r.id_gedung = g.id_gedung
                ORDER BY r.id_ruangan ASC";

        return $pdo->query($sql)->fetchAll();
    }

    /**
     * Filter ruangan
     */
    public static function filter($q, $idGedung) {
        $pdo = Database::getConnection();
        $conditions = [];
        $params = [];

        $sql = "SELECT 
                    r.id_ruangan,
                    r.kode_ruangan,
                    r.id_gedung,
                    r.kapasitas,
                    r.lokasi_ruangan,
                    r.keterangan,
                    g.nama_gedung,
                    g.lokasi AS lokasi_gedung
                FROM ruangan r
                INNER JOIN gedung g ON r.id_gedung = g.id_gedung";

        if ($q !== '') {
            $conditions[] = "r.kode_ruangan LIKE ?";
            $params[] = "%$q%";
        }

        if ($idGedung > 0) {
            $conditions[] = "r.id_gedung = ?";
            $params[] = $idGedung;
        }

        if (!empty($conditions)) {
            $sql .= " WHERE " . implode(" AND ", $conditions);
        }

        $sql .= " ORDER BY r.id_ruangan ASC";

        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll();
    }

    /**
     * Ambil satu ruangan berdasarkan ID
     */
    public static function find($id) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("
            SELECT 
                r.*,
                g.nama_gedung,
                g.lokasi AS lokasi_gedung
            FROM ruangan r
            INNER JOIN gedung g ON r.id_gedung = g.id_gedung
            WHERE r.id_ruangan = ?
        ");
        $stmt->execute([$id]);
        return $stmt->fetch();
    }

    /**
     * Insert ruangan baru
     */
    public static function create($kode, $idGedung, $kapasitas, $lokasi, $keterangan) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("
            INSERT INTO ruangan 
                (kode_ruangan, id_gedung, kapasitas, lokasi_ruangan, keterangan)
            VALUES (?, ?, ?, ?, ?)
        ");

        return $stmt->execute([$kode, $idGedung, $kapasitas, $lokasi, $keterangan]);
    }

    /**
     * Update data ruangan
     */
    public static function update($id, $kode, $idGedung, $kapasitas, $lokasi, $keterangan) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("
            UPDATE ruangan 
            SET kode_ruangan = ?, 
                id_gedung = ?, 
                kapasitas = ?, 
                lokasi_ruangan = ?, 
                keterangan = ?
            WHERE id_ruangan = ?
        ");

        return $stmt->execute([$kode, $idGedung, $kapasitas, $lokasi, $keterangan, $id]);
    }

    /**
     * Delete ruangan
     */
    public static function delete($id) {
        $pdo = Database::getConnection();
        $stmt = $pdo->prepare("DELETE FROM ruangan WHERE id_ruangan = ?");
        return $stmt->execute([$id]);
    }

    /**
     * Cek kode duplikat
     */
    public static function existsKode($kode, $excludeId = null) {
        $pdo = Database::getConnection();

        if ($excludeId) {
            $stmt = $pdo->prepare("
                SELECT 1 
                FROM ruangan 
                WHERE kode_ruangan = ? AND id_ruangan != ? 
                LIMIT 1
            ");
            $stmt->execute([$kode, $excludeId]);
        } else {
            $stmt = $pdo->prepare("
                SELECT 1 
                FROM ruangan 
                WHERE kode_ruangan = ? 
                LIMIT 1
            ");
            $stmt->execute([$kode]);
        }

        return (bool)$stmt->fetchColumn();
    }
}
