<?php
require_once __DIR__ . '/../../Config/Database.php';

class ProdiModel {
    public static function all() {
        $pdo = Database::getConnection();
        return $pdo->query("SELECT * FROM prodi ORDER BY id_prodi ASC")->fetchAll();
    }

    public static function find($id) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("SELECT * FROM prodi WHERE id_prodi = ?");
        $st->execute([$id]);
        return $st->fetch();
    }

    public static function create($nama) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("INSERT INTO prodi (nama_prodi) VALUES (?)");
        return $st->execute([$nama]);
    }

    public static function update($id, $nama) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("UPDATE prodi SET nama_prodi = ? WHERE id_prodi = ?");
        return $st->execute([$nama, $id]);
    }

    public static function delete($id) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("DELETE FROM prodi WHERE id_prodi = ?");
        return $st->execute([$id]);
    }

    public static function existsByName($nama, $excludeId = null) {
        $pdo = Database::getConnection();
        if ($excludeId) {
            $st = $pdo->prepare("SELECT 1 FROM prodi WHERE nama_prodi = ? AND id_prodi != ? LIMIT 1");
            $st->execute([$nama, $excludeId]);
        } else {
            $st = $pdo->prepare("SELECT 1 FROM prodi WHERE nama_prodi = ? LIMIT 1");
            $st->execute([$nama]);
        }
        return (bool)$st->fetchColumn();
    }
}
