<?php
require_once __DIR__ . '/../../Config/Database.php';

class LogModel {
    public static function write($jenis, $idReferensi, $aksi, $oleh) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("INSERT INTO log_aktivitas (jenis,id_referensi,aksi,oleh,waktu) VALUES (?,?,?,?,NOW())");
        return $st->execute([$jenis, (int)$idReferensi, $aksi, $oleh]);
    }

    public static function search($f) {
        $pdo = Database::getConnection();
        $sql = "SELECT * FROM log_aktivitas WHERE 1=1";
        $args = [];
        if ($f['jenis'] !== '') { $sql.=" AND jenis = ?"; $args[] = $f['jenis']; }
        if ($f['aksi']  !== '') { $sql.=" AND aksi  = ?"; $args[] = $f['aksi']; }
        if ($f['q']     !== '') {
            $sql.=" AND (oleh LIKE ? OR CAST(id_referensi AS CHAR) LIKE ?)";
            $kw = '%'.$f['q'].'%'; array_push($args,$kw,$kw);
        }
        if ($f['dari']   !== '') { $sql.=" AND DATE(waktu) >= ?"; $args[] = $f['dari']; }
        if ($f['sampai'] !== '') { $sql.=" AND DATE(waktu) <= ?"; $args[] = $f['sampai']; }
        $sql.=" ORDER BY waktu DESC";
        $st = $pdo->prepare($sql);
        $st->execute($args);
        return $st->fetchAll();
    }
}
