<?php
require_once __DIR__ . '/../../Config/Database.php';

class DosenModel {
    public static function all() {
        $pdo = Database::getConnection();
        return $pdo->query("SELECT * FROM dosen ORDER BY id_dosen ASC")->fetchAll();
    }

    public static function search($q) {
        $pdo = Database::getConnection();
        $like = '%'.$q.'%';
        $st = $pdo->prepare("SELECT * FROM dosen 
                             WHERE inisial LIKE ? OR nama_lengkap LIKE ?
                             ORDER BY id_dosen ASC");
        $st->execute([$like, $like]);
        return $st->fetchAll();
    }

    public static function find($id) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("SELECT * FROM dosen WHERE id_dosen = ?");
        $st->execute([$id]);
        return $st->fetch();
    }

    public static function create($inisial, $nama) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("INSERT INTO dosen (inisial, nama_lengkap) VALUES (?, ?)");
        return $st->execute([$inisial, $nama]);
    }

    public static function update($id, $inisial, $nama) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("UPDATE dosen SET inisial = ?, nama_lengkap = ? WHERE id_dosen = ?");
        return $st->execute([$inisial, $nama, $id]);
    }

    public static function delete($id) {
        $pdo = Database::getConnection();
        $st = $pdo->prepare("DELETE FROM dosen WHERE id_dosen = ?");
        return $st->execute([$id]);
    }

    public static function existsInisial($inisial, $excludeId = null) {
        $pdo = Database::getConnection();
        if ($excludeId) {
            $st = $pdo->prepare("SELECT 1 FROM dosen WHERE inisial = ? AND id_dosen != ? LIMIT 1");
            $st->execute([$inisial, $excludeId]);
        } else {
            $st = $pdo->prepare("SELECT 1 FROM dosen WHERE inisial = ? LIMIT 1");
            $st->execute([$inisial]);
        }
        return (bool)$st->fetchColumn();
    }
}
