<?php
require_once __DIR__ . '/../../Config/Database.php';

class BookingModel {

    // 🔍 Ambil semua booking + join
    public static function allWithJoins($idDosenFilter = 0) {
        $pdo = Database::getConnection();

        $sql = "SELECT b.*, d.nama_lengkap AS nama_dosen, r.kode_ruangan, g.nama_gedung, 
                       h.nama_hari, sw.jam_mulai, sw.jam_selesai
                FROM booking_ruangan b
                JOIN dosen d       ON d.id_dosen = b.id_dosen
                JOIN ruangan r     ON r.id_ruangan = b.id_ruangan
                JOIN gedung g      ON g.id_gedung = r.id_gedung
                JOIN hari h        ON h.id_hari = b.id_hari
                JOIN slot_waktu sw ON sw.id_slot = b.id_slot";

        $args = [];

        if ($idDosenFilter > 0) {
            $sql .= " WHERE b.id_dosen = ?";
            $args[] = $idDosenFilter;
        }

        $sql .= " ORDER BY b.diajukan_pada DESC";

        $st = $pdo->prepare($sql);
        $st->execute($args);
        return $st->fetchAll();
    }

    // 🔍 Cari 1 booking
    public static function find($id) {
        $st = Database::getConnection()
            ->prepare("SELECT * FROM booking_ruangan WHERE id_booking = ?");
        $st->execute([$id]);
        return $st->fetch();
    }

    // ➕ Tambah booking baru
    public static function create($p) {
        $pdo = Database::getConnection();

        $sql = "INSERT INTO booking_ruangan
                (id_dosen,id_ruangan,id_hari,id_slot,jumlah_sks,tanggal,
                 mata_kuliah,kelas,keperluan,status,diajukan_pada)
                VALUES (?,?,?,?,?,?,?,?,?,'diajukan',NOW())";

        $st = $pdo->prepare($sql);

        return $st->execute([
            $p['id_dosen'], $p['id_ruangan'], $p['id_hari'], $p['id_slot'],
            $p['jumlah_sks'], $p['tanggal'], $p['mata_kuliah'],
            $p['kelas'], $p['keperluan']
        ]);
    }

    // 🔄 Update status (approve, tolak, batal)
    public static function setStatus($id, $status) {
        $pdo = Database::getConnection();

        if ($status === 'disetujui') {
            $sql = "UPDATE booking_ruangan 
                    SET status='disetujui', disetujui_pada = NOW() 
                    WHERE id_booking = ?";
        } 
        else if ($status === 'ditolak') {
            $sql = "UPDATE booking_ruangan 
                    SET status='ditolak', disetujui_pada = NULL 
                    WHERE id_booking = ?";
        } 
        else { // dibatalkan
            $sql = "UPDATE booking_ruangan 
                    SET status='dibatalkan' 
                    WHERE id_booking = ?";
        }

        $st = $pdo->prepare($sql);
        return $st->execute([$id]);
    }

    // 💥 CEK KONFLIK — versi FIXED supaya TIDAK bentrok dengan dirinya sendiri
    public static function isConflict($p) {
        $pdo = Database::getConnection();

        $sql = "SELECT id_booking FROM booking_ruangan
                WHERE id_ruangan = ?
                  AND id_hari = ?
                  AND id_slot = ?
                  AND tanggal = ?
                  AND status IN ('diajukan','disetujui')";

        $params = [
            $p['id_ruangan'],
            $p['id_hari'],
            $p['id_slot'],
            $p['tanggal']
        ];

        // ❗ Abaikan dirinya sendiri saat proses approve
        if (!empty($p['id_booking'])) {
            $sql .= " AND id_booking != ?";
            $params[] = $p['id_booking'];
        }

        $sql .= " LIMIT 1";

        $st = $pdo->prepare($sql);
        $st->execute($params);

        return (bool) $st->fetchColumn();
    }

}
