<?php
require_once __DIR__ . '/../models/RuanganModel.php';
require_once __DIR__ . '/../models/GedungModel.php';

class RuanganController {

    public function index() {
        $q = trim($_GET['q'] ?? '');
        $gedung = (int)($_GET['id_gedung'] ?? 0);
        $gedungList = GedungModel::all();

        if ($q === '' && $gedung === 0) {
            $list = RuanganModel::allWithGedung();
        } else {
            $list = RuanganModel::filter($q, $gedung);
        }

        require BASE_PATH . '/app/views/ruangan/index.php';
    }

    public function add() {
        $gedungList = GedungModel::all();

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {

            $kode = trim($_POST['kode_ruangan'] ?? '');
            $id_gedung = trim($_POST['id_gedung'] ?? '');
            $kapasitas = trim($_POST['kapasitas'] ?? '');
            $lokasi = trim($_POST['lokasi'] ?? '');
            $keterangan = trim($_POST['keterangan'] ?? '');

            if ($kode === '' || $id_gedung === '' || $kapasitas === '' || $lokasi === '') {
                $_SESSION['flash'] = 'Semua field wajib diisi.';
                header("Location: index.php?route=ruangan_add"); exit;
            }

            if (!ctype_digit($kapasitas) || (int)$kapasitas <= 0) {
                $_SESSION['flash'] = 'Kapasitas harus angka > 0.';
                header("Location: index.php?route=ruangan_add"); exit;
            }

            if (!ctype_digit($id_gedung) || (int)$id_gedung <= 0) {
                $_SESSION['flash'] = 'Gedung tidak valid.';
                header("Location: index.php?route=ruangan_add"); exit;
            }

            if (RuanganModel::existsKode($kode)) {
                $_SESSION['flash'] = 'Kode ruangan sudah digunakan.';
                header("Location: index.php?route=ruangan_add"); exit;
            }

            RuanganModel::create($kode, (int)$id_gedung, (int)$kapasitas, $lokasi, $keterangan);

            $_SESSION['flash'] = 'Ruangan berhasil ditambahkan ✅';
            header("Location: index.php?route=ruangan"); 
            exit;
        }

        require BASE_PATH . '/app/views/ruangan/form_add.php';
    }

    public function edit() {
        $id = (int)($_GET['id'] ?? 0);
        $data = RuanganModel::find($id);

        if (!$data) {
            $_SESSION['flash'] = 'Data tidak ditemukan.';
            header("Location: index.php?route=ruangan"); exit;
        }

        $gedungList = GedungModel::all();

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {

            $kode = trim($_POST['kode_ruangan'] ?? '');
            $id_gedung = trim($_POST['id_gedung'] ?? '');
            $kapasitas = trim($_POST['kapasitas'] ?? '');
            $lokasi_ruangan = trim($_POST['lokasi_ruangan'] ?? '');
            $keterangan = trim($_POST['keterangan'] ?? '');

            if ($kode === '' || $id_gedung === '' || $kapasitas === '' || $lokasi === '') {
                $_SESSION['flash'] = 'Semua field wajib diisi.';
                header("Location: index.php?route=ruangan_edit&id=".$id); exit;
            }

            if (!ctype_digit($kapasitas) || (int)$kapasitas <= 0) {
                $_SESSION['flash'] = 'Kapasitas harus angka > 0.';
                header("Location: index.php?route=ruangan_edit&id=".$id); exit;
            }

            if (!ctype_digit($id_gedung) || (int)$id_gedung <= 0) {
                $_SESSION['flash'] = 'Gedung tidak valid.';
                header("Location: index.php?route=ruangan_edit&id=".$id); exit;
            }

            if (RuanganModel::existsKode($kode, $id)) {
                $_SESSION['flash'] = 'Kode ruangan sudah digunakan.';
                header("Location: index.php?route=ruangan_edit&id=".$id); exit;
            }

            RuanganModel::update($id, $kode, (int)$id_gedung, (int)$kapasitas, $lokasi_ruangan, $keterangan);

            $_SESSION['flash'] = 'Ruangan berhasil diperbarui ✨';
            header("Location: index.php?route=ruangan"); exit;
        }

        require BASE_PATH . '/app/views/ruangan/form_edit.php';
    }

    public function delete() {
        $id = (int)($_GET['id'] ?? 0);
        RuanganModel::delete($id);
        $_SESSION['flash'] = 'Ruangan berhasil dihapus 🗑️';
        header("Location: index.php?route=ruangan"); exit;
    }
}
