<?php
require_once __DIR__ . '/../models/ProdiModel.php';

class ProdiController {
    public function index() {
        $list = ProdiModel::all();
        require BASE_PATH . '/app/views/prodi/index.php';
    }

    public function add() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $nama = trim($_POST['nama_prodi'] ?? '');
            if ($nama === '') {
                $_SESSION['flash'] = 'Nama Prodi tidak boleh kosong.';
                header("Location: index.php?route=prodi_add"); exit;
            }
            if (ProdiModel::existsByName($nama)) {
                $_SESSION['flash'] = 'Nama Prodi sudah ada.';
                header("Location: index.php?route=prodi_add"); exit;
            }
            ProdiModel::create($nama);
            $_SESSION['flash'] = 'Prodi berhasil ditambahkan ✅';
            header("Location: index.php?route=prodi"); exit;
        }
        require BASE_PATH . '/app/views/prodi/form_add.php';
    }

    public function edit() {
        $id = (int)($_GET['id'] ?? 0);
        $data = ProdiModel::find($id);
        if (!$data) { $_SESSION['flash'] = 'Data tidak ditemukan.'; header("Location: index.php?route=prodi"); exit; }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $nama = trim($_POST['nama_prodi'] ?? '');
            if ($nama === '') {
                $_SESSION['flash'] = 'Nama Prodi tidak boleh kosong.';
                header("Location: index.php?route=prodi_edit&id=".$id); exit;
            }
            if (ProdiModel::existsByName($nama, $id)) {
                $_SESSION['flash'] = 'Nama Prodi sudah digunakan.';
                header("Location: index.php?route=prodi_edit&id=".$id); exit;
            }
            ProdiModel::update($id, $nama);
            $_SESSION['flash'] = 'Prodi berhasil diperbarui ✨';
            header("Location: index.php?route=prodi"); exit;
        }

        require BASE_PATH . '/app/views/prodi/form_edit.php';
    }

    public function delete() {
        $id = (int)($_GET['id'] ?? 0);
        ProdiModel::delete($id);
        $_SESSION['flash'] = 'Prodi berhasil dihapus 🗑️';
        header("Location: index.php?route=prodi"); exit;
    }
}
