<?php
require_once __DIR__ . '/../models/PengajuanModel.php';
require_once __DIR__ . '/../models/ProdiModel.php';
require_once __DIR__ . '/../models/MataKuliahModel.php';
require_once __DIR__ . '/../models/DosenModel.php';
require_once __DIR__ . '/../models/RuanganModel.php';
require_once __DIR__ . '/../models/HariModel.php';
require_once __DIR__ . '/../models/SlotModel.php';
require_once __DIR__ . '/../models/KelasModel.php';
require_once __DIR__ . '/../models/JadwalModel.php';
require_once __DIR__ . '/../models/LogModel.php'; // NEW

class PengajuanController {
    public function index() {
        $idProdiFilter = 0;
        if (!empty($_SESSION['user']) && $_SESSION['user']['role'] === 'prodi') {
            $idProdiFilter = (int)($_SESSION['user']['id_prodi'] ?? 0);
        }
        $list = PengajuanModel::allWithJoins($idProdiFilter);
        require BASE_PATH . '/app/views/pengajuan/index.php';
    }

    public function add() {
        $prodiList  = ProdiModel::all();
        $mkList     = MataKuliahModel::allWithProdi();
        $dosenList  = DosenModel::all();
        $ruangList  = RuanganModel::allWithGedung();
        $hariList   = HariModel::all();
        $slotList   = SlotModel::all();
        $kelasList  = KelasModel::all();

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $p = [
                'id_prodi'        => (int)($_POST['id_prodi'] ?? 0),
                'id_mk'           => (int)($_POST['id_mk'] ?? 0),
                'id_kelas'        => (int)($_POST['id_kelas'] ?? 0),
                'id_dosen'        => (int)($_POST['id_dosen'] ?? 0),
                'id_ruangan'      => (int)($_POST['id_ruangan'] ?? 0),
                'id_hari'         => (int)($_POST['id_hari'] ?? 0),
                'id_slot'         => (int)($_POST['id_slot'] ?? 0),
                'jumlah_sks'      => (int)($_POST['jumlah_sks'] ?? 2),
                'tanggal_mulai'   => trim($_POST['tanggal_mulai'] ?? ''),
                'tanggal_selesai' => trim($_POST['tanggal_selesai'] ?? ''),
                'keterangan'      => trim($_POST['keterangan'] ?? ''),
                'diajukan_oleh'   => $_SESSION['user']['username'] ?? 'prodi',
            ];
            foreach (['id_prodi','id_mk','id_kelas','id_dosen','id_ruangan','id_hari','id_slot'] as $k) {
                if ($p[$k] <= 0) { $_SESSION['flash']='Semua field wajib diisi.'; header("Location: index.php?route=pengajuan_add"); exit; }
            }
            if ($p['jumlah_sks']<1 || $p['jumlah_sks']>3) { $_SESSION['flash']='Jumlah SKS 1–3.'; header("Location:index.php?route=pengajuan_add"); exit; }
            if ($p['tanggal_mulai']==='' || $p['tanggal_selesai']==='' || $p['tanggal_mulai']>$p['tanggal_selesai']) {
                $_SESSION['flash']='Rentang tanggal tidak valid.'; header("Location:index.php?route=pengajuan_add"); exit;
            }
            if (PengajuanModel::isConflict($p)) {
                $_SESSION['flash']='Bentrok: ruangan/hari/slot pada rentang itu sudah dipakai.'; header("Location:index.php?route=pengajuan_add"); exit;
            }
            PengajuanModel::create($p);
            // log
            LogModel::write('pengajuan_jadwal', 0, 'dibuat', $p['diajukan_oleh']);
            $_SESSION['flash']='Pengajuan berhasil dikirim ✅';
            header("Location:index.php?route=pengajuan"); exit;
        }

        require BASE_PATH . '/app/views/pengajuan/form_add.php';
    }

    public function approve() {
        if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
            $_SESSION['flash'] = 'Hanya admin yang bisa menyetujui.';
            header("Location: index.php?route=pengajuan"); exit;
        }
        $id = (int)($_GET['id'] ?? 0);
        $pj = PengajuanModel::find($id);
        if (!$pj) { $_SESSION['flash']='Pengajuan tidak ditemukan.'; header("Location:index.php?route=pengajuan"); exit; }

        $p = [
            'id_ruangan'=>$pj['id_ruangan'], 'id_hari'=>$pj['id_hari'], 'id_slot'=>$pj['id_slot'],
            'tanggal_mulai'=>$pj['tanggal_mulai'], 'tanggal_selesai'=>$pj['tanggal_selesai']
        ];
        if (PengajuanModel::isConflict($p)) {
            $_SESSION['flash']='Gagal setujui: jadwal bentrok.'; header("Location:index.php?route=pengajuan"); exit;
        }

        $ok = JadwalModel::createFromPengajuan($pj);
        if (!$ok) { $_SESSION['flash']='Gagal menulis ke tabel jadwal.'; header("Location:index.php?route=pengajuan"); exit; }

        PengajuanModel::setStatus($id, 'disetujui');
        // log
        LogModel::write('pengajuan_jadwal', $id, 'disetujui', $_SESSION['user']['username'] ?? 'admin');
        $_SESSION['flash']='Pengajuan disetujui dan jadwal dibuat ✅';
        header("Location:index.php?route=pengajuan"); exit;
    }

    public function reject() {
        if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
            $_SESSION['flash'] = 'Hanya admin yang bisa menolak.';
            header("Location: index.php?route=pengajuan"); exit;
        }
        $id = (int)($_GET['id'] ?? 0);
        $pj = PengajuanModel::find($id);
        if (!$pj) { $_SESSION['flash']='Pengajuan tidak ditemukan.'; header("Location:index.php?route=pengajuan"); exit; }

        PengajuanModel::setStatus($id, 'ditolak');
        // log
        LogModel::write('pengajuan_jadwal', $id, 'ditolak', $_SESSION['user']['username'] ?? 'admin');
        $_SESSION['flash']='Pengajuan ditolak.';
        header("Location:index.php?route=pengajuan"); exit;
    }
}
