<?php
require_once BASE_PATH . '/app/models/JadwalViewModel.php';
require_once BASE_PATH . '/app/models/ProdiModel.php';
require_once BASE_PATH . '/app/models/RuanganModel.php';
require_once BASE_PATH . '/app/models/HariModel.php';
require_once BASE_PATH . '/app/models/SlotModel.php';
// ✅ Tambahkan model yang dibutuhkan untuk edit/hapus
require_once BASE_PATH . '/app/models/JadwalModel.php';
require_once BASE_PATH . '/app/models/MataKuliahModel.php';
require_once BASE_PATH . '/app/models/KelasModel.php';
require_once BASE_PATH . '/app/models/DosenModel.php';


class JadwalController {
    public function index() {
        // === FILTER DARI QUERY STRING ===
        $q = [
            'id_prodi'        => (int)($_GET['id_prodi']   ?? 0),
            'id_ruangan'      => (int)($_GET['id_ruangan'] ?? 0),
            'id_hari'         => (int)($_GET['id_hari']    ?? 0),
            'id_gedung'       => (int)($_GET['id_gedung']  ?? 0),
            'hari'            => trim($_GET['hari'] ?? ''),
            'tanggal'         => trim($_GET['tanggal'] ?? ''),
            'tanggal_dari'    => trim($_GET['dari'] ?? ''),
            'tanggal_sampai'  => trim($_GET['sampai'] ?? ''),
            'sumber'          => trim($_GET['sumber'] ?? ''), // '', tetap, pengganti
            'keyword'         => trim($_GET['q'] ?? ''),
        ];

        // === JIKA SEMUA FILTER KOSONG, TAMPILKAN SEMUA JADWAL ===
        $semuaKosong = (
            empty($q['id_prodi']) &&
            empty($q['id_ruangan']) &&
            empty($q['id_hari']) &&
            empty($q['id_gedung']) &&
            empty($q['hari']) &&
            empty($q['tanggal']) &&
            empty($q['tanggal_dari']) &&
            empty($q['tanggal_sampai']) &&
            empty($q['sumber']) &&
            empty($q['keyword'])
        );

        if ($semuaKosong) {
            $list = JadwalViewModel::search([]);
        } else {
            $list = JadwalViewModel::search($q);
        }

        $prodiList = ProdiModel::all();
        $ruangList = RuanganModel::allWithGedung();
        $hariList  = HariModel::all();
        $slotList  = SlotModel::all();

        require BASE_PATH . '/app/views/jadwal/index.php';
    }

    // ✅ TAMBAHKAN METHOD EDIT DI SINI
    public function edit() {
        if (empty($_SESSION['user'])) {
            header("Location: index.php?route=login");
            exit;
        }

        $id = (int)($_GET['id'] ?? 0);
        if ($id <= 0) {
            header('Location: index.php?route=jadwal');
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $id_hari = (int)($_POST['id_hari'] ?? 0);
            $id_slot = (int)($_POST['id_slot'] ?? 0);
            $id_ruangan = (int)($_POST['id_ruangan'] ?? 0);
            $id_mk = !empty($_POST['id_mk']) ? (int)$_POST['id_mk'] : null;
            $id_kelas = !empty($_POST['id_kelas']) ? (int)$_POST['id_kelas'] : null;
            $id_dosen = (int)($_POST['id_dosen'] ?? 0);
            $jumlah_sks = (int)($_POST['jumlah_sks'] ?? 1);
            $sumber = $_POST['sumber'] ?? 'tetap';
            $tanggal_mulai = !empty($_POST['tanggal_mulai']) ? $_POST['tanggal_mulai'] : null;
            $tanggal_selesai = !empty($_POST['tanggal_selesai']) ? $_POST['tanggal_selesai'] : null;

            if ($id_hari && $id_slot && $id_ruangan && $id_dosen && $jumlah_sks >= 1) {
                JadwalModel::update($id, [
                    'id_hari' => $id_hari,
                    'id_slot' => $id_slot,
                    'id_ruangan' => $id_ruangan,
                    'id_mk' => $id_mk,
                    'id_kelas' => $id_kelas,
                    'id_dosen' => $id_dosen,
                    'jumlah_sks' => $jumlah_sks,
                    'sumber' => $sumber,
                    'tanggal_mulai' => $tanggal_mulai,
                    'tanggal_selesai' => $tanggal_selesai,
                ]);
                $_SESSION['message'] = ['type' => 'success', 'text' => 'Jadwal berhasil diperbarui.'];
            } else {
                $_SESSION['message'] = ['type' => 'error', 'text' => 'Hari, slot, ruangan, dosen, dan SKS wajib diisi.'];
            }
            header('Location: index.php?route=jadwal');
            exit;
        }

        $jadwal = JadwalModel::find($id);
        if (!$jadwal) {
            header('Location: index.php?route=jadwal');
            exit;
        }

        $hariList = HariModel::all();
        $slotList = SlotModel::all();
        $ruangList = RuanganModel::allWithGedung();
        $mkList = MataKuliahModel::all();
        $kelasList = KelasModel::all();
        $dosenList = DosenModel::all();

        include BASE_PATH . '/app/views/jadwal/edit.php';
    }

    // ✅ TAMBAHKAN METHOD DELETE DI SINI
    public function delete() {
        if (empty($_SESSION['user'])) {
            header("Location: index.php?route=login");
            exit;
        }

        $id = (int)($_GET['id'] ?? 0);
        if ($id > 0) {
            JadwalModel::delete($id);
            $_SESSION['message'] = ['type' => 'success', 'text' => 'Jadwal berhasil dihapus.'];
        }
        header('Location: index.php?route=jadwal');
        exit;
    }
}