<?php
require_once __DIR__ . '/../models/BookingModel.php';
require_once __DIR__ . '/../models/RuanganModel.php';
require_once __DIR__ . '/../models/HariModel.php';
require_once __DIR__ . '/../models/SlotModel.php';
require_once __DIR__ . '/../models/DosenModel.php';
require_once __DIR__ . '/../models/JadwalModel.php';
require_once __DIR__ . '/../models/LogModel.php';

class BookingController {

    // ============================
    // LIST BOOKING
    // ============================
    public function index() {
        $idDosenFilter = 0;

        if (!empty($_SESSION['user']) && $_SESSION['user']['role'] === 'dosen') {
            $idDosenFilter = (int)($_SESSION['user']['id_dosen'] ?? 0);
        }

        $list = BookingModel::allWithJoins($idDosenFilter);
        require BASE_PATH . '/app/views/booking/index.php';
    }


    // ============================
    // ADD BOOKING
    // ============================
    public function add() {
        $ruangList = RuanganModel::allWithGedung();
        $hariList  = HariModel::all();
        $slotList  = SlotModel::all();
        $dosenList = DosenModel::all();

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {

            $p = [
                'id_dosen'   => (int)($_POST['id_dosen'] ?? ($_SESSION['user']['id_dosen'] ?? 0)),
                'id_ruangan' => (int)($_POST['id_ruangan'] ?? 0),
                'id_hari'    => (int)($_POST['id_hari'] ?? 0),
                'id_slot'    => (int)($_POST['id_slot'] ?? 0),
                'jumlah_sks' => (int)($_POST['jumlah_sks'] ?? 1),
                'tanggal'    => trim($_POST['tanggal'] ?? ''),
                'mata_kuliah'=> trim($_POST['mata_kuliah'] ?? ''),
                'kelas'      => trim($_POST['kelas'] ?? ''),
                'keperluan'  => trim($_POST['keperluan'] ?? ''),
                'id_booking' => 0   // penting: agar konflik tidak mendeteksi dirinya sendiri
            ];

            // Validasi field wajib
            if ($p['id_ruangan'] <= 0 || $p['id_hari'] <= 0 || $p['id_slot'] <= 0) {
                $_SESSION['flash'] = "Semua field wajib diisi.";
                header("Location:index.php?route=booking_add"); exit;
            }

            // Cek bentrok
            if (BookingModel::isConflict($p)) {
                $_SESSION['flash'] = "Bentrok: ruangan sudah digunakan pada hari & slot tersebut.";
                header("Location:index.php?route=booking_add"); exit;
            }

            // Simpan booking
            BookingModel::create($p);
            LogModel::write('booking_ruangan', 0, 'dibuat', $_SESSION['user']['username'] ?? 'user');

            $_SESSION['flash'] = 'Booking diajukan ✅';
            header("Location:index.php?route=booking"); exit;
        }

        require BASE_PATH . '/app/views/booking/form_add.php';
    }


    // ============================
    // APPROVE BOOKING
    // ============================
    public function approve() {

        if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
            $_SESSION['flash'] = 'Hanya admin yang bisa menyetujui';
            header("Location:index.php?route=booking"); exit;
        }

        $id = (int)($_GET['id'] ?? 0);
        $bk = BookingModel::find($id);

        if (!$bk) {
            $_SESSION['flash'] = 'Booking tidak ditemukan.';
            header("Location:index.php?route=booking"); exit;
        }

        if ($bk['status'] !== 'diajukan') {
            $_SESSION['flash'] = 'Status bukan diajukan.';
            header("Location:index.php?route=booking"); exit;
        }

        // Data untuk pengecekan bentrok
        $p = [
            'id_ruangan' => $bk['id_ruangan'],
            'id_hari'    => $bk['id_hari'],
            'id_slot'    => $bk['id_slot'],
            'tanggal'    => $bk['tanggal'],
            'id_booking' => $bk['id_booking']  // ini akan diabaikan saat cek bentrok
        ];

        // Cek konflik saat approve
        if (BookingModel::isConflict($p)) {
            $_SESSION['flash'] = "Tidak bisa disetujui: jadwal bentrok dengan peminjaman lain.";
            header("Location:index.php?route=booking"); exit;
        }

        // Simpan ke tabel jadwal
        if (!JadwalModel::createFromBooking($bk)) {
            $_SESSION['flash'] = 'Gagal menyimpan ke tabel jadwal.';
            header("Location:index.php?route=booking"); exit;
        }

        // Update status
        BookingModel::setStatus($id, 'disetujui');

        LogModel::write('booking_ruangan', $id, 'disetujui', $_SESSION['user']['username'] ?? 'admin');

        $_SESSION['flash'] = 'Booking disetujui dan masuk ke jadwal ✅';
        header("Location:index.php?route=booking"); exit;
    }


    // ============================
    // REJECT BOOKING
    // ============================
    public function reject() {

        if (empty($_SESSION['user']) || $_SESSION['user']['role'] !== 'admin') {
            $_SESSION['flash'] = 'Hanya admin yang bisa menolak.';
            header("Location:index.php?route=booking"); exit;
        }

        $id = (int)($_GET['id'] ?? 0);
        $bk = BookingModel::find($id);

        if (!$bk) {
            $_SESSION['flash'] = 'Booking tidak ditemukan.';
            header("Location:index.php?route=booking"); exit;
        }

        BookingModel::setStatus($id, 'ditolak');
        LogModel::write('booking_ruangan', $id, 'ditolak', $_SESSION['user']['username'] ?? 'admin');

        $_SESSION['flash'] = 'Booking ditolak ❌';
        header("Location:index.php?route=booking"); exit;
    }
}
