<?php
require_once __DIR__ . '/../models/AuthModel.php';

class AuthController {
    public function login() {
        // jika sudah login arahkan langsung ke dashboard
        if (!empty($_SESSION['user'])) {
            header("Location: index.php");
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $username = trim($_POST['username'] ?? '');
            $password = $_POST['password'] ?? '';

            $user = AuthModel::verifyLogin($username, $password);

            if ($user) {
                $_SESSION['user'] = [
                    'id_user' => $user['id_user'],
                    'username' => $user['username'],
                    'nama_lengkap' => $user['nama_lengkap'],
                    'role' => $user['role']
                ];
                header("Location: index.php");
                exit;
            } else {
                $error = "Username atau password salah.";
                require BASE_PATH . '/app/views/auth/login.php';
            }
        } else {
            require BASE_PATH . '/app/views/auth/login.php';
        }
    }

    public function logout() {
        session_destroy();
        header("Location: index.php?route=login");
        exit;
    }
}
